﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataWebService.ModelsEnumTypes;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.Xrm.Sdk.Metadata;
using System.Net.Http;

namespace PpmsDataWebService.VistaPharmacyModels
{
    public class VistaPharmacyResponse
    {
        [Key]
        public string Status { get; set; }

        public int ProvidersTotalResults { get; set; }

        public int ProvidersReturnedResults { get; set; }

        public int ProvidersPageNumber { get; set; }

        public int ProvidersTotalPages { get; set; }

        public int ProviderServicesTotalResults { get; set; }

        public int ProviderServicesReturnedResults { get; set; }

        public int ProviderServicesPageNumber { get; set; }

        public int ProviderServicesTotalPages { get; set; }

        public int ProviderIdentifiersTotalResults { get; set; }

        public int ProviderIdentifiersReturnedResults { get; set; }

        public int ProviderIdentifiersPageNumber { get; set; }

        public int ProviderIdentifiersTotalPages { get; set; }

        public int DEAsTotalResults { get; set; }

        public int DEAsReturnedResults { get; set; }

        public int DEAsPageNumber { get; set; }

        public int DEAsTotalPages { get; set; }

        public int MedicalEducationsTotalResults { get; set; }

        public int MedicalEducationsReturnedResults { get; set; }

        public int MedicalEducationsPageNumber { get; set; }

        public int MedicalEducationsTotalPages { get; set; }

        public int MaxResultsPerPage { get; set; }

        public virtual IQueryable<VistaPharmacyProvider> Providers { get; set; }

        public virtual IQueryable<VistaPharmacyProviderService> ProviderServices { get; set; }

        public virtual IQueryable<VistaPharmacyProviderIdentifier> ProviderIdentifiers { get; set; }

        public virtual IQueryable<VistaPharmacyDEA> DEAs { get; set; }

        public virtual IQueryable<VistaPharmacyMedicalEducation> MedicalEducations { get; set; }

    }
}